/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.tools.logic.InteractionHandler;
import slimeknights.tconstruct.tools.modifiers.ability.armor.DoubleJumpModifier;

public enum TinkerControlPacket implements IThreadsafePacket
{
    DOUBLE_JUMP,
    START_HELMET_INTERACT,
    STOP_HELMET_INTERACT,
    START_LEGGINGS_INTERACT,
    STOP_LEGGINGS_INTERACT;


    public static TinkerControlPacket read(FriendlyByteBuf buffer) {
        return (TinkerControlPacket)buffer.m_130066_(TinkerControlPacket.class);
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130068_((Enum)this);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null) {
            switch (this) {
                case DOUBLE_JUMP: {
                    DoubleJumpModifier.extraJump((Player)player);
                    break;
                }
                case START_HELMET_INTERACT: {
                    InteractionHandler.startArmorInteract((Player)player, EquipmentSlot.HEAD);
                    break;
                }
                case STOP_HELMET_INTERACT: {
                    InteractionHandler.stopArmorInteract((Player)player, EquipmentSlot.HEAD);
                    break;
                }
                case START_LEGGINGS_INTERACT: {
                    InteractionHandler.startArmorInteract((Player)player, EquipmentSlot.LEGS);
                    break;
                }
                case STOP_LEGGINGS_INTERACT: {
                    InteractionHandler.stopArmorInteract((Player)player, EquipmentSlot.LEGS);
                }
            }
        }
    }
}

